import csv
import pdb
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import ListedColormap

arr = np.genfromtxt("../outputs/hg00733calls.txt",delimiter='\t',dtype=str)


xhmmcalls = arr[:,15]
deccalls = arr[:,16]
NQs = arr[:,9]
SQs = arr[:,10]
length = arr[:,3]

correctedids = xhmmcalls != deccalls
notcorrectedids = xhmmcalls == deccalls

SQscorrected = length[correctedids]
SQsnotcorrected = length[notcorrectedids]
NQscorrected = [0 for x in SQscorrected]
NQsnotcorrected = [0.1 for x in SQsnotcorrected]



plt.scatter(NQscorrected,SQscorrected, s=250, c='black',marker="*",label='DECoNT corrected true XHMM calls', alpha=0.8)
plt.scatter(NQsnotcorrected, SQsnotcorrected,  s=250, c='yellow',marker="*",label='True XHMM calls', alpha=0.8)


plt.ylabel("CNV length in kilobase")
plt.xticks([0,0.1],["DECoNT corrected true calls","True XHMM calls"])

#plt.legend(loc='upper left')

plt.show()

pdb.set_trace()
plt.show()

pdb.set_trace()